// Middleware to check if user is a patient
export const isPatient = (req, res, next) => {
  if (req.user.role !== "patient") {
    return res.status(403).json({ message: "Access denied. Patient role required." });
  }
  next();
};

// Middleware to check if user is a doctor
export const isDoctor = (req, res, next) => {
  if (req.user.role !== "doctor") {
    return res.status(403).json({ message: "Access denied. Doctor role required." });
  }
  next();
};


